import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../../company_auth_logic.dart';
import 'collection_account_info.dart';
import 'debit_account_info.dart';
import 'funds_info.dart';

class PayInfo extends StatelessWidget {
  final CompanyAuthLogic logic;
  const PayInfo({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return GetBuilder(
      init: logic,
      builder: ((controller) {
        return Column(
          children: [
            vGap10,
            FundsInfo(logic: logic, onChanged: logic.receiveAmount),
            vGap10,
            DebitAccountInfo(
              logic: logic,
            ),
            vGap10,
            CollectionAccountInfo(logic: logic),
            vGap50,
            GestureTapWidget(
              onTap: logic.uploadBusinessInfo,
              child: Container(
                alignment: Alignment.center,
                height: 50,
                margin: EdgeInsets.only(
                  left: 25,
                  right: 25,
                  bottom: MediaQuery.of(context).padding.bottom + 15,
                ),
                decoration: BoxDecoration(
                  color: StyleParams.themeColor,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Text(
                  '提交',
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: 15,
                      fontWeight: FontWeight.w600),
                ),
              ),
            ),
          ],
        );
      }),
    );
  }
}
