import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/attribute_string.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import '../../company_auth_logic.dart';

class FundsInfo extends StatefulWidget {
  final ValueChanged<String>? onChanged;
  final CompanyAuthLogic logic;
  const FundsInfo({super.key, this.onChanged, required this.logic});

  @override
  State<StatefulWidget> createState() {
    return _FundsInfo();
  }
}

class _FundsInfo extends State<FundsInfo> {
  final TextEditingController _controller = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.all(20),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            '打款信息',
            style: TextStyle(
                color: Color(0xff000000),
                fontSize: 18,
                fontWeight: FontWeight.w600),
          ),
          vGap10,
          CLXAttributeString()
              .add(
                  '请你联系公司财务在',
                  TextStyle(
                      color: Color(0xff88909B),
                      fontSize: 14,
                      fontWeight: FontWeight.w400))
              .add(
                  widget.logic.bankInfoModel.expiredTime ?? '',
                  TextStyle(
                      color: StyleParams.themeColor,
                      fontSize: 14,
                      fontWeight: FontWeight.w600))
              .add(
                  '前完成金额确认，否则将认证失败。',
                  TextStyle(
                      color: Color(0xff88909B),
                      fontSize: 14,
                      fontWeight: FontWeight.w400))
              .richText,
          vGap20,
          Text(
            '验证金额',
            style: TextStyle(
                color: Color(0xff344254),
                fontSize: 16,
                fontWeight: FontWeight.w500),
          ),
          vGap10,
          Container(
            padding: const EdgeInsets.only(left: 12),
            decoration: BoxDecoration(
              color: Color(0xffF7F8FA),
              borderRadius: BorderRadius.circular(8),
            ),
            child: Row(
              children: [
                Text(
                  '0.',
                  style: TextStyle(
                      color: StyleParams.themeColor,
                      fontSize: 20,
                      fontWeight: FontWeight.w600),
                ),
                Expanded(
                  child: TextField(
                      controller: _controller,
                      textAlignVertical: TextAlignVertical.center,
                      keyboardType: TextInputType.number,
                      maxLength: 2,
                      autofocus: true,
                      onChanged: widget.onChanged,
                      style: TextStyle(
                          color: StyleParams.themeColor,
                          fontSize: 20,
                          fontWeight: FontWeight.w600),
                      cursorColor: StyleParams.themeColor,
                      inputFormatters: [
                        FilteringTextInputFormatter.digitsOnly,
                      ],
                      decoration: InputDecoration(
                        border: const OutlineInputBorder(
                            borderSide: BorderSide.none),
                        counterText: '',
                        isCollapsed: true,
                        hintText: '请输入验证金额',
                        hintStyle: const TextStyle(
                          fontSize: 15,
                          color: Color(0xffC9CDD4),
                          fontWeight: FontWeight.w400,
                        ),
                        suffixIcon: Container(
                          padding: EdgeInsetsDirectional.only(
                            start: 2.0,
                            end: 0.0,
                          ),
                          child: InkWell(
                            onTap: (() {
                              setState(() {
                                _controller.clear();
                              });
                            }),
                            child: const Icon(
                              Icons.cancel,
                              size: 20.0,
                              color: Color(0xffC9CDD4),
                            ),
                          ),
                        ),
                      )),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
