import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

import '../../model/legal_person_info_model.dart';
import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/input_field.dart';
import '../common/validity_alert.dart';

class LegalPersonInfo extends StatelessWidget {
  final LegalPersonInfoModel? model;
  final InputOnChange? onChanged;
  final ValidityCallBack? confirmCallBack;
  const LegalPersonInfo({
    super.key,
    this.model,
    this.onChanged,
    this.confirmCallBack,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 20, right: 20, top: 20, bottom: 10),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CLXAttributeString()
              .add('请确认', normalStyle)
              .add('法人', lightStyle)
              .add('身份信息', normalStyle)
              .richText,
          vGap10,
          InputField(
            title: '姓名',
            maxLength: 25,
            minLength: 2,
            value: model?.name,
            onChanged: (value) {
              if (onChanged != null) {
                onChanged!(0, value);
              }
            },
          ),
          InputField(
            title: '身份证号',
            value: model?.idCard,
            minLength: 15,
            maxLength: 18,
            onChanged: (value) {
              if (onChanged != null) {
                onChanged!(1, value);
              }
            },
          ),
          InputField(
            title: '有效期',
            placeholder: '请选择有效期',
            enabled: false,
            value: model?.validityTime,
            keyboardType: TextInputType.none,
            tapCallback: () {
              Get.bottomSheet(
                ValidityAlert(
                  startTime: model?.startTime,
                  endTime: model?.endTime,
                  isIndefinite: model?.isIndefinite ?? false,
                  confirmCallBack: confirmCallBack,
                ),
                isDismissible: false,
                enableDrag: false,
              );
            },
          ),
        ],
      ),
    );
  }
}
