import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/profile_upload.dart';

class BusinessLicenseUpload extends StatelessWidget {
  final String? url;
  final String? error;
  final ImageUploadCallBack callBack;
  const BusinessLicenseUpload({
    super.key,
    required this.callBack,
    this.url,
    this.error,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.all(20),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CLXAttributeString()
              .add('上传', normalStyle)
              .add('营业', lightStyle)
              .add('执照信息', normalStyle)
              .richText,
          vGap10,
          Text(
            '请确保证件边框完整、字体清晰、亮度均匀',
            style: TextStyle(
                color: Color(0xff88909B),
                fontSize: 14,
                fontWeight: FontWeight.w400),
          ),
          ProfileUpload(
            title: '营业执照',
            detail: '上传营业执照正面',
            backgroundImgName: 'business_license_upload',
            size: Size(181, 242),
            error: error,
            url: url,
            callBack: callBack,
          )
        ],
      ),
    );
  }
}
