import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

import '../../company_auth_logic.dart';
import './top_step_item.dart';

class TopStepWidget extends StatelessWidget {
  final CompanyAuthLogic logic;
  const TopStepWidget({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 62,
      color: Colors.white,
      child: GetBuilder(
          init: logic,
          builder: ((controller) {
            return Row(
              children: [
                TopStepItem(
                  title: '上传信息',
                  status: _getNodeStatus(0),
                  type: NodeType.star,
                ),
                TopStepItem(
                  title: '企业信息',
                  status: _getNodeStatus(-1),
                  type: NodeType.end,
                ),
                // TopStepItem(title: '对公账户', status: _getNodeStatus(1)),
                // TopStepItem(title: '账户确认', status: _getNodeStatus(2)),
                // TopStepItem(
                //   title: '打款确认',
                //   status: _getNodeStatus(3),
                //   type: NodeType.end,
                // ),
              ],
            );
          })),
    );
  }

  StepStatus _getNodeStatus(int step) {
    /// 如果是填写代理人信息步骤
    if (step == -1) {
      if (logic.currStep == -1) {
        return StepStatus.doing;
      } else if (logic.currStep > 0) {
        return StepStatus.finsh;
      } else {
        return StepStatus.wait;
      }
    }
    if (logic.currStep == -1) {
      if (step == 0) {
        return StepStatus.finsh;
      } else {
        return StepStatus.wait;
      }
    }
    if (step < logic.currStep) {
      return StepStatus.finsh;
    } else if (step == logic.currStep) {
      return StepStatus.doing;
    } else {
      return StepStatus.wait;
    }
  }
}
