import 'package:account_center/common/utils/image_load.dart';
import 'package:flutter/material.dart';

class DrawDashBorder extends StatelessWidget {
  final double width;
  final double height;
  final double borderSize;
  final Widget? child;
  final Decoration? decoration;
  final EdgeInsetsGeometry? padding;
  const DrawDashBorder({
    super.key,
    this.width = 100,
    this.height = 100,
    this.borderSize = 10,
    this.child,
    this.decoration,
    this.padding,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      width: width,
      height: height,
      alignment: Alignment.center,
      child: Stack(
        children: [
          Positioned(
            top: 0,
            left: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('topleft'),
          ),
          Positioned(
            top: 0,
            right: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('topright'),
          ),
          Positioned(
            bottom: 0,
            left: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('bottomleft'),
          ),
          Positioned(
            bottom: 0,
            right: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('bottomright'),
          ),
          if (child != null)
            Padding(
              padding: padding ?? EdgeInsets.zero,
              child: child,
            ),
        ],
      ),
    );
  }
}
