import 'package:flutter/material.dart';

extension CLXDateTime on DateTime {
  String get toYMD {
    String res = '';
    res = year.toString();
    if (month < 10) {
      res = '$res-0${month.toString()}';
    } else {
      res = '$res-${month.toString()}';
    }
    if (day < 10) {
      res = '$res-0${day.toString()}';
    } else {
      res = '$res-${day.toString()}';
    }
    return res;
  }

  String get toYMDStart => '$toYMD 00:00:00';
  String get toYMDEnd => '$toYMD 23:59:59';

  String get toYMDHms {
    String res = '';
    res = year.toString();
    if (month < 10) {
      res = '$res-0${month.toString()}';
    } else {
      res = '$res-${month.toString()}';
    }
    if (day < 10) {
      res = '$res-0${day.toString()}';
    } else {
      res = '$res-${day.toString()}';
    }
    if (hour < 10) {
      res = '$res 0${hour.toString()}';
    } else {
      res = '$res ${hour.toString()}';
    }
    if (minute < 10) {
      res = '$res-0${minute.toString()}';
    } else {
      res = '$res-${minute.toString()}';
    }
    if (second < 10) {
      res = '$res-0${second.toString()}';
    } else {
      res = '$res-${second.toString()}';
    }
    return res;
  }
}

extension CLXString on String {
  /// 时间字符串转时间类型
  DateTime? get dateTime => DateTime.tryParse(this);

  /// 是否是时间字符串
  bool get isTimeStr {
    DateTime? tempTime = dateTime;
    tempTime ??= replaceAll(RegExp(r'.'), '-').dateTime;
    tempTime ??= replaceAll(RegExp(r'/'), '-').dateTime;
    tempTime ??= replaceAll(RegExp(r' '), '-').dateTime;
    return tempTime != null;
  }

  /// 给定时间是否早于
  bool isBefore(String timeStr) {
    if (isTimeStr) {
      if (timeStr.isTimeStr) {
        return dateTime!.isBefore(timeStr.dateTime!);
      } else {
        return true;
      }
    } else {
      return false;
    }
  }

  /// 给定时间是否晚于
  bool isAfter(String timeStr) {
    if (isTimeStr) {
      if (timeStr.isTimeStr) {
        return dateTime!.isAfter(timeStr.dateTime!);
      } else {
        return true;
      }
    } else {
      return false;
    }
  }

  /// 给定时间是否相等
  bool isSame(String timeStr) {
    if (isTimeStr) {
      if (timeStr.isTimeStr) {
        return dateTime!.isAtSameMomentAs(timeStr.dateTime!);
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
}

extension CLXBuildContext on BuildContext {
  /// 获取Widget的Y坐标点
  double get getY {
    var box = findRenderObject();
    if (box is RenderBox) {
      return box.localToGlobal(Offset.zero).dy;
    } else {
      return 0;
    }
  }

  /// 获取Widget的X坐标点
  double get getX {
    var box = findRenderObject();
    if (box is RenderBox) {
      return box.localToGlobal(Offset.zero).dx;
    } else {
      return 0;
    }
  }
}
