import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:account_center/widget/send_code_button.dart';
import 'package:flutter/material.dart';

class CertificationDialog extends StatefulWidget {
  final dynamic data;
  final Future<bool> Function()? sendCode;
  const CertificationDialog({
    super.key,
    this.data,
    this.sendCode,
  });

  @override
  State<CertificationDialog> createState() => _CertificationDialogState();
}

class _CertificationDialogState extends State<CertificationDialog> {
  final _codeController = TextEditingController();

  final _focusNode = FocusNode();

  @override
  Widget build(BuildContext context) {
    return Dialog(
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: Colors.white,
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            SizedBox(
              height: 20,
            ),
            Container(
              padding: const EdgeInsets.symmetric(horizontal: 20),
              child: Text(
                '验证通过后或即可完成企业认证，请联系人获取相关验证码~',
                style: TextStyle(fontSize: 16),
              ),
            ),
            FormShow(title: '代理人', content: widget.data['authorizerName']),
            FormShow(title: '手机号', content: widget.data['authorizerMobile']),
            FormInput(
              title: '验证码',
              controller: _codeController,
              focusNode: _focusNode,
              maxLength: 6,
              endWidget: SendCodeButton(
                sendCode: widget.sendCode ?? _sendCode,
              ),
            ),
            SizedBox(
              height: 10,
            ),
            Row(
              children: [
                Expanded(
                  child: ButtonPublicRadiusOutline(
                      text: '返回',
                      margin: EdgeInsets.only(left: 20, right: 5),
                      onPress: () {
                        Get.back();
                      }),
                ),
                Expanded(
                  child: ButtonPublicRadius(
                    text: '验证',
                    margin: EdgeInsets.only(left: 5, right: 20),
                    onPress: _check,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20),
          ],
        ),
      ),
    );
  }

  _check() async {
    if (_codeController.text.length != 6) {
      AlertUtil.showCenterToast('请输入6位验证码');
      return;
    }
    LoadingUtils.showLoading();
    var result = await fetchAsync(
      Method.get,
      url: '/msl-user/app/company/realName/innerAuthCaptchaVerify',
      queryParameters: {
        'authorizerMobile': widget.data['authorizerMobile'],
        'companyNo': widget.data['companyNo'],
        'captchaCode': _codeController.text,
      },
    );
    LoadingUtils.dismiss();
    if (result.isSuccess) {
      bool isFinish = result.data?['finished'] == true;
      if (isFinish) {
        Get.back(result: result.data?['verifySuccess'] == true);
      } else {
        AlertUtil.showCenterToast('验证码错误');
      }
    }
  }

  Future<bool> _sendCode() async {
    var result = await fetchAsync(
      Method.get,
      url: '/msl-user/app/company/realName/sendInnerAuthCaptcha',
      queryParameters: {
        'authorizerMobile': widget.data['authorizerMobile'],
        'companyNo': widget.data['companyNo'],
      },
    );
    return result.isSuccess;
  }
}
