import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../../company_auth_logic.dart';
import 'agent_info_widget.dart';
import 'confirm_business_info.dart';

class AgentInfo extends StatelessWidget {
  final CompanyAuthLogic logic;
  const AgentInfo({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return GetBuilder(
      init: logic,
      builder: ((controller) {
        return Column(
          children: [
            vGap10,

            /// 代理人信息
            AgentInfoWidget(
              model: logic.agentInfoModel,
              onChanged: logic.receiveAgentSms,
            ),

            vGap10,

            /// 企业信息
            ConfirmBusinessInfo(
              busniessName: logic.businessInfoModel?.companyName,
              busniessCode: logic.businessInfoModel?.groupCode,
              legalName: logic.legalPersonInfoModel?.name,
            ),
            vGap50,

            GestureTapWidget(
              onTap: logic.startEsignVerify,
              child: Container(
                alignment: Alignment.center,
                height: 50,
                margin: EdgeInsets.only(
                  left: 25,
                  right: 25,
                  bottom: MediaQuery.of(context).padding.bottom + 15,
                ),
                decoration: BoxDecoration(
                  color: StyleParams.themeColor,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Text(
                  '发起认证',
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: 15,
                      fontWeight: FontWeight.w600),
                ),
              ),
            ),
          ],
        );
      }),
    );
  }
}
