import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class BankListItem extends StatelessWidget {
  final dynamic item;
  final bool isSelect;
  const BankListItem({super.key, this.item, this.isSelect = false});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(top: 10),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(6),
        border: Border.all(
            color: isSelect ? StyleParams.themeColor : Color(0xffE1E1E2),
            width: 1),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            item?['bank'],
            style: TextStyle(
                color: Color(0xff171A1D),
                fontSize: 16,
                fontWeight: FontWeight.w400),
          ),
          Text(
            '${item?['bankName']}(${item?['province']}${item?['city']})',
            style: TextStyle(
                color: Color(0xffCDD0D6),
                fontSize: 14,
                fontWeight: FontWeight.w400),
          ),
        ],
      ),
    );
  }
}
