import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

import '../common/company_define.dart';
import '../common/search.dart';
import 'bank_list_item.dart';
import 'bank_list_logic.dart';

class BankListAlert extends StatelessWidget {
  final DynamicCallBack? selectCallBack;
  final Map<String, dynamic>? selectBank;
  final BankListLogic logic;
  const BankListAlert({
    super.key,
    this.selectCallBack,
    this.selectBank,
    required this.logic,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.all(20),
      height: MediaQuery.of(context).size.height / 2,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.vertical(
          top: Radius.circular(20),
        ),
        color: Colors.white,
      ),
      child: Column(
        children: [
          CLXSearchBar(
            placeholder: '请输入银行名称',
            defaultValue: logic.searchKey,
            onSearch: logic.getSuportBankList,
            autofocus: true,
          ),
          vGap10,
          GetBuilder(
              init: logic,
              global: false,
              builder: ((controller) {
                return Expanded(
                  child: ListView.builder(
                      itemCount: logic.bankList.length,
                      itemBuilder: ((context, index) {
                        return GestureTapWidget(
                          onTap: () {
                            Get.back();
                            if (selectCallBack != null) {
                              selectCallBack!(logic.bankList[index]);
                            }
                          },
                          child: BankListItem(
                            item: logic.bankList[index],
                            isSelect: logic.bankList[index]['cnapsCode'] ==
                                selectBank?['cnapsCode'],
                          ),
                        );
                      })),
                );
              }))
        ],
      ),
    );
  }
}
