import 'package:account_center/account_center.dart';

class LegalPersonInfoModel {
  /// 身份证正面
  String? faceUrl;

  /// 身份证反面
  String? backUrl;

  /// 姓名
  String? name;

  /// 身份证号码
  String? idCard;

  /// 身份证有效期-生效时间
  String? startTime;

  /// 身份证有效期-失效时间
  String? endTime;

  /// 是否长期有效
  bool isIndefinite = false;

  /// 有效期
  String? get validityTime {
    if (isIndefinite) {
      return '长期有效';
    }
    if (startTime?.isTimeStr == true && endTime?.isTimeStr == true) {
      return '$startTime 至 $endTime';
    }
    return null;
  }

  Map<String, dynamic> toJson() {
    return {
      'cardBackImg': backUrl,
      'cardBeginDate': startTime,
      'cardEndDate': endTime,
      'cardFaceImg': faceUrl,
      'idCardNo': idCard,
      'longTermFlag': isIndefinite ? 1 : 0,
      'name': name,
    };
  }

  fromJson(Map<String, dynamic>? json) {
    faceUrl = json?['legalCardFrontImg'];
    backUrl = json?['legalCardBackImg'];
    name = json?['legalName'];
    idCard = json?['legalCardNo'];
    startTime = json?['startTime'];
    endTime = json?['endTime'];
    isIndefinite = json?['isIndefinite'] ?? false;
  }

  /// 营业执照信息是否有效
  bool get isValid {
    if (getTXTString(name).isEmpty == true) {
      return false;
    }
    if (getTXTString(name).length < 2 || getTXTString(name).length > 25) {
      return false;
    }
    if (getTXTString(idCard).isEmpty == true) {
      return false;
    }
    if (getTXTString(idCard).length < 15 || getTXTString(idCard).length > 18) {
      return false;
    }

    if (!isIndefinite && getTXTString(endTime).isEmpty == true) {
      return false;
    }
    if (getTXTString(startTime).isEmpty == true) {
      return false;
    }
    return true;
  }

  /// 错误信息展示
  String get errorMsg {
    if (getTXTString(name).isEmpty == true) {
      return '姓名不能为空';
    }
    if (getTXTString(name).length < 2 || getTXTString(name).length > 25) {
      return '姓名不合规';
    }
    if (getTXTString(idCard).isEmpty == true) {
      return '身份证号码不能为空';
    }
    if (getTXTString(idCard).length < 15 || getTXTString(idCard).length > 18) {
      return '身份证号码不合规';
    }

    if (!isIndefinite && getTXTString(endTime).isEmpty == true) {
      return '身份证有效结束时间不能为空';
    }
    if (getTXTString(startTime).isEmpty == true) {
      return '身份证有效开始时间不能为空';
    }
    return '';
  }
}
