import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_center/widget/change_name_tip.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/page/account_center/widget/user_real_name_message.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class IdentitySuccess extends StatefulWidget {
  const IdentitySuccess({super.key});

  @override
  State<IdentitySuccess> createState() => _IdentitySuccessState();
}

class _IdentitySuccessState extends State<IdentitySuccess> {
  dynamic _userInfo;

  int cardExpireFlag = 0;

  @override
  void initState() {
    _requestUserInfo();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '实名认证',
      ),
      body: SingleChildScrollView(
        child: Column(
          children: [
            Visibility(
              visible: cardExpireFlag == 1,
              child: topTip(1),
            ),
            Visibility(
              visible: cardExpireFlag == 2,
              child: topTip(2),
            ),
            SizedBox(
              height: 10,
            ),
            ResultLayout(
              title: '认证成功',
              icon: 'circle_success',
            ),
            SizedBox(
              height: 10,
            ),
            UserRealNameMessage(getUserNo()),
            SizedBox(
              height: 10,
            ),
            ChangeNameTip()
          ],
        ),
      ),
      bottomNavigationBar: Visibility(
        visible: _userInfo?['cardUpdating'] == 0,
        child: SafeArea(
          child: ButtonPublicRadius(
            text: '更新身份证有效期',
            onPress: () {
              Get.offNamed(RouteConfig.identityUserIdCardPage,
                  arguments: {'isChangeDate': true});
            },
            margin: EdgeInsets.only(bottom: 20, left: 20, right: 20),
          ),
        ),
      ),
    );
  }

  void _requestUserInfo() {
    fetch(Method.get,
        url: HttpApi.getUserRealNameInfo,
        queryParameters: {'userNo': getUserNo()}, onSuccess: (response) {
      setState(() {
        _userInfo = response;
        cardExpireFlag = response['cardExpireStatus'];
      });
    });
  }

  Widget topTip(int val) {
    return Container(
      height: 40,
      width: double.infinity,
      decoration: BoxDecoration(
        color: Color(val == 1 ? 0xFFFFEFEA : 0xFFFFF9ED),
      ),
      child: Row(
        children: [
          Expanded(
            child: Row(
              children: [
                SizedBox(width: 12),
                ImageLoad.loadAssertImage(
                  val == 1 ? 'danger_sound' : 'warning_sound',
                  width: 18,
                  height: 18,
                ),
                SizedBox(width: 8),
                Text(
                  val == 1 ? '身份证已到期，请立即更新' : '身份证即将到期，请及时更新',
                  style: TextStyle(
                    color: Color(val == 1 ? 0xFFEA5529 : 0xFFFF8F1F),
                  ),
                ),
              ],
            ),
          ),
          IconButton(
            onPressed: () {
              setState(() {
                cardExpireFlag = 0;
              });
            },
            icon: Icon(
              Icons.close,
              size: 18,
              color: Color(val == 1 ? 0xFFEA5529 : 0xFFFF8F1F),
            ),
          )
        ],
      ),
    );
  }
}
