import 'package:account_center/common/utils/bottom_dialog.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:url_launcher/url_launcher.dart';

class ChangeNameTip extends StatelessWidget {
  const ChangeNameTip({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      padding: EdgeInsets.symmetric(horizontal: 24, vertical: 13),
      width: double.infinity,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.min,
        children: [
          Text(
            '您已实名认证',
            maxLines: null,
            style: TextStyle(
                fontSize: 15,
                color: Color(0xff171A1D),
                fontWeight: FontWeight.w500),
          ),
          RichText(
              text: TextSpan(children: [
            TextSpan(
              text: '如需修改姓名，请联系客服：',
              style: TextStyle(
                  fontSize: 14,
                  color: Color(0xff171A1D),
                  fontWeight: FontWeight.w400),
            ),
            TextSpan(
                text: '400-8350677',
                style: TextStyle(
                  fontSize: 14,
                  color: StyleParams.themeColor,
                  fontWeight: FontWeight.w600,
                ),
                recognizer: TapGestureRecognizer()
                  ..onTap = () {
                    BottomDialog.showBottomDialog([
                      ButtonItem(
                          title: '拨打电话给 4008350677',
                          onClick: () {
                            launchUrl(Uri(scheme: 'tel', path: '4008350677'));
                          })
                    ]);
                  })
          ]))
        ],
      ),
    );
  }
}
