import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class IdentityResult extends StatefulWidget {
  final bool isSuccess;
  final String? failReason;
  const IdentityResult({super.key, required this.isSuccess, this.failReason});

  @override
  State<IdentityResult> createState() => _IdentityDoingState();
}

class _IdentityDoingState extends State<IdentityResult> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar(
        '认证结果',
      ),
      body: ResultLayout(
        title: widget.isSuccess ? '认证成功' : '实名认证未通过',
        icon: widget.isSuccess ? 'circle_success' : 'circle_failed',
        buttonText: widget.isSuccess ? '完成' : '再次认证',
        secondTitle: widget.isSuccess ? null : widget.failReason,
        onTap: () {
          if (widget.isSuccess) {
            Navigator.pop(context);
          } else {
            Get.offNamed(RouteConfig.identityUserIdCardPage);
          }
        },
      ),
    );
  }
}
