import 'package:account_center/common/utils/reg_exp.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'user_seal_identification_logic.dart';

class UserSealIdentificationPage extends GetView<UserSealIdentificationLogic> {
  const UserSealIdentificationPage({super.key});

  UserSealIdentificationLogic get logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('个人签名'),
      body: GetBuilder<UserSealIdentificationLogic>(
        builder: (logic) {
          return Column(
            children: [
              Container(
                width: double.infinity,
                color: Colors.white,
                padding: EdgeInsets.only(left: 20, top: 20, bottom: 10),
                margin: EdgeInsets.only(top: 10),
                child: Text(
                  '您好，您将使用以下信息进行个人签名授权，请谨慎操作',
                  style: TextStyle(
                      color: Colors.black,
                      fontSize: 18,
                      fontWeight: FontWeight.w600),
                ),
              ),
              FormShow(
                title: '姓名',
                content: logic.userInfo?['name'] ?? '',
              ),
              FormShow(
                title: '身份证',
                content: logic.userInfo?['idCardNo'] ?? '',
              ),
              Container(
                height: 10,
                width: double.infinity,
                color: Colors.white,
              ),
              SizedBox(height: 10),
              FormRow(
                title: '手机号',
                vCap: 3,
                child: Row(
                  children: [
                    Expanded(
                      child: Text(
                        logic.userPhone ?? '',
                        style: TextStyle(
                            color: Color(0xff344254),
                            fontSize: 16,
                            fontWeight: FontWeight.w500),
                      ),
                    ),
                    SendVCode(
                      '',
                      () {
                        return logic.userPhone ?? '';
                      },
                      onSend: logic.sendCode,
                    )
                  ],
                ),
              ),
              FormInput(
                title: '验证码',
                controller: logic.codeController,
                focusNode: logic.codeNode,
                regExp: RegExpUtil.num(),
                check: logic.check,
                maxLength: 6,
                // inputType: TextInputType.number,
                getErrText: () {
                  return logic.codeController.text.length == 6
                      ? ''
                      : '请输入正确的验证码';
                },
              ),
            ],
          );
        },
      ),
      bottomNavigationBar: SafeArea(
        child: ButtonPublicRadius(
          margin: EdgeInsets.only(bottom: 10, left: 15, right: 15),
          text: "确定",
          onPress: logic.confirm,
        ),
      ),
    );
  }
}
