import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

class SignHistoryItem extends StatelessWidget {
  final dynamic item;
  final Function(dynamic item) contractDetail;

  const SignHistoryItem(
      {super.key, required this.item, required this.contractDetail});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 15, right: 15, top: 15),
      padding: const EdgeInsets.all(15),
      decoration: BoxDecoration(
          color: Colors.white, borderRadius: BorderRadius.circular(8)),
      width: double.infinity,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text('签名调用时间: 2024/01/18 15:32:15'),
          vGap20,
          Text('调用产品:         数煤宝'),
          vGap10,
          Text('签署文件:         煤贸交易合同'),
          vGap10,
          Text('文件编号:         XV125321235441'),
          vGap15,
          GestureTapWidget(
            child: Container(
              height: 40,
              width: 100,
              decoration: BoxDecoration(
                color: Colors.amber,
                borderRadius: BorderRadius.circular(8),
              ),
              alignment: Alignment.center,
              child: Text(
                '合同预览',
                style: TextStyle(color: Colors.white),
              ),
            ),
          )
        ],
      ),
    );
  }
}
