import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/progress_loading.dart';
import 'package:account_center/page/account_center/account_center_logic.dart';
import 'package:account_center/page/account_center/account_info/account_info_logic.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'modify_name_state.dart';

class ModifyNameLogic extends GetxController {
  final ModifyNameState state = ModifyNameState();
  bool isReal = false;
  @override
  void onInit() {
    state.nameController.text = getUserName() ?? '';
    isReal = Get.arguments?['isRealName'] == true;
    super.onInit();
  }

  @override
  void onReady() {
    state.nameFocusNode.requestFocus();
    super.onReady();
  }

  void changeName() {
    var name = state.nameController.text;
    if (name.isEmpty) {
      ToastUtil.showToast('请输入姓名');
      return;
    }
    showLoading();
    fetch(
      Method.post,
      url: HttpApi.updateUser,
      params: {'userName': name, 'userNo': SpUtil.getString(SPKey.userNo)},
      onSuccess: (response) {
        Get.find<AccountCenterLogic>().changeName(name);
        Get.find<AccountInfoLogic>().changeName(name);
        Get.back();
        ToastUtil.showToast('修改成功');
        dismissLoading();
      },
      onError: (code, message) {},
    );
  }
}
