import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/unordered_list.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'change_phone_confirm_logic.dart';

class ChangePhoneConfirmPage extends StatelessWidget {
  final logic = Get.find<ChangePhoneConfirmLogic>();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('修改手机号'),
      body: SingleChildScrollView(
        child: Column(
          children: [
            Container(
              margin: EdgeInsets.only(top: 10),
              padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
              color: Colors.white,
              width: double.infinity,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  SizedBox(height: 5),
                  Center(
                    child: AssetImageWidget(
                      imgFileName: 'circle_warning',
                      width: 52,
                      height: 52,
                    ),
                  ),
                  SizedBox(height: 20),
                  Center(
                    child: Text(
                      '修改账户绑定的手机号',
                      style: TextStyle(
                        fontSize: 17,
                        color: Color(0xFF171A1D),
                        fontWeight: FontWeight.w400,
                      ),
                    ),
                  ),
                  Center(
                    child: Text(
                      logic.getShowPhone(),
                      style: TextStyle(
                        fontSize: 17,
                        color: Color(0xFF171A1D),
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  SizedBox(height: 8),
                  Text(
                    '请注意以下事项：',
                    style: TextStyle(
                        fontSize: 14.0, color: Color(0xFF344254), height: 1.45),
                  ),
                  UnorderedList(
                    items: [
                      '如果您正在进行实名认证或已完成实名认证，手机号更换后需要重新进行实名认证。',
                    ],
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(top: 10),
              padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
              color: Colors.white,
              width: double.infinity,
              child: Column(
                children: [
                  UnorderedList(
                    items: [
                      '手机号更换以后会在以下产品同步更换，请使用新手机号登录',
                    ],
                  ),
                  GetBuilder<ChangePhoneConfirmLogic>(builder: (logic) {
                    return Container(
                      alignment: Alignment.centerLeft,
                      padding: EdgeInsets.symmetric(horizontal: 5),
                      child: GridView.count(
                        shrinkWrap: true,
                        physics: NeverScrollableScrollPhysics(),
                        crossAxisCount: 5,
                        mainAxisSpacing: 5,
                        children: logic.products.map<Widget>((e) {
                          return Container(
                            padding: EdgeInsets.symmetric(horizontal: 5),
                            child: Column(
                              mainAxisSize: MainAxisSize.min,
                              children: [
                                ImageLoad.productIcon(e['productImgUrl'],
                                    width: 40, height: 40),
                                SizedBox(
                                  height: 6,
                                ),
                                Flexible(
                                  child: Text(
                                    e['productName'] ?? '',
                                    style: TextStyle(
                                        fontSize: 13, color: Color(0xFF344254)),
                                    maxLines: 1,
                                    overflow: TextOverflow.ellipsis,
                                  ),
                                )
                              ],
                            ),
                          );
                        }).toList(),
                      ),
                    );
                  })
                ],
              ),
            ),
          ],
        ),
      ),
      bottomNavigationBar: SafeArea(
        child: Container(
          color: Colors.white,
          margin: EdgeInsets.only(top: 5),
          padding: EdgeInsets.only(top: 5),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ButtonPublicRadius(
                text: '仍要修改',
                onPress: () {
                  logic.changePhone();
                },
                margin: EdgeInsets.symmetric(horizontal: 25),
              ),
              SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
