import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/hint_text.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'change_password_logic.dart';

class ChangePasswordPage extends StatelessWidget {
  final logic = Get.find<ChangePasswordLogic>();
  final state = Get.find<ChangePasswordLogic>().state;

  ChangePasswordPage({super.key});

  final textStyle1 = TextStyle(
      fontSize: 24, color: Color(0xFF344254), fontWeight: FontWeight.w500);
  final textStyle2 = TextStyle(fontSize: 16, color: Color(0xFF687582));

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar("修改密码"),
      children: [
        vGap30,
        Row(
          children: [
            hGap60,
            Text(
              "修改密码",
              style: textStyle1,
            ),
          ],
        ),
        vGap5,
        Row(
          children: [
            hGap60,
            Text(
              "需验证当前手机号",
              style: TextStyle(fontSize: 14, color: Color(0xFFA3A8B2)),
            ),
          ],
        ),
        vGap25,
        GetBuilder<ChangePasswordLogic>(builder: (logic) {
          return Container(
            padding: EdgeInsets.only(left: 40, right: 40),
            child: Column(
              children: [
                Container(
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8),
                    color: Color(0xFFF7F8FA),
                  ),
                  padding: EdgeInsets.symmetric(vertical: 13),
                  child: Row(
                    children: [
                      hGap15,
                      SizedBox(
                        width: 80,
                        child: Text(
                          "手机号",
                          style: textStyle2,
                        ),
                      ),
                      Text(
                        state.userMobile,
                        style: textStyle2,
                      ),
                      hGap5,
                    ],
                  ),
                ),
                vGap15,
                _buildInput(
                  "验证码",
                  "请输入",
                  state.vCodeController,
                  state.codeNode,
                  end: SendVCode(
                    'captchaUserPwd',
                    () => state.userMobile,
                  ),
                  maxLength: 6,
                  showErr: logic.codeErr,
                  errText: logic.codeErrText,
                ),
                vGap15,
                _buildInput(
                  "新密码",
                  "请输入",
                  state.newPwdController,
                  state.newPwdFocusNode,
                  isPass: true,
                  showErr: logic.passErr,
                  errText: logic.passErrText,
                ),
                vGap15,
                _buildInput(
                  "确认密码",
                  "请输入",
                  state.confirmPwdController,
                  state.confirmPwdFocusNode,
                  isPass: true,
                  showErr: logic.confirmPassErr,
                  errText: logic.confirmPassErrText,
                ),
                vGap50,
                ButtonPublicRadius(
                  margin: EdgeInsets.zero,
                  text: "确定",
                  onPress: () {
                    logic.updateLoginUserForPwd();
                  },
                ),
              ],
            ),
          );
        })
      ],
    );
  }

  Widget _buildInput(String title, String hint,
      TextEditingController controller, FocusNode focusNode,
      {Widget? end,
      bool isPass = false,
      int maxLength = 16,
      bool showErr = true,
      String errText = "error"}) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
            color: Color(0xFFF7F8FA),
            border: Border.all(
              color: showErr ? Color(0xFFE02020) : Color(0xFFF7F8FA),
              width: 1,
            ),
          ),
          child: Row(
            children: [
              hGap15,
              SizedBox(
                width: 80,
                child: Text(
                  title,
                  style: textStyle2,
                ),
              ),
              Expanded(
                child: HintText(
                  controller,
                  hint,
                  maxLength: maxLength,
                  focusNode: focusNode,
                  isPass: isPass,
                ),
              ),
            ]..addIf(end != null, end ?? Container()),
          ),
        ),
        Visibility(
          visible: showErr,
          child: Container(
            margin: EdgeInsets.only(left: 10, top: 5),
            child: Text(
              errText,
              style: TextStyle(color: Color(0xFFE02020)),
            ),
          ),
        ),
      ],
    );
  }
}
