import 'dart:async';
import 'dart:io';

import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/page/account_center/widget/Identity_doing.dart';
import 'package:account_center/page/account_center/widget/identity_success.dart';
import 'package:aliyun_face_plugin/core/aliyun_face_plugin.dart';
import 'package:aliyun_face_plugin/utils/face_auth_utils.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/services.dart';

abstract class IdentificationUtil {
  static Future<dynamic>? toIdentificationPage(int? status) {
    switch (status) {
      case 1:

      /// 未认证
      case 3:

        /// 人工审核失败
        /// 去填写认证信息
        return Get.toNamed(RouteConfig.identityUserIdCardPage);
      case 2:

        /// 人工审核中
        return Get.to(IdentityDoing());
      case 4:

      /// 身份信息验证通过，待人脸验证
      case 6:

        /// 人工审核通过
        /// 打开人脸验证页面。 页面调整成功会吧人脸识别的url和id返回
        return startFaceVerify();
      case 5:

        /// 已认证
        return Get.to(IdentitySuccess());
      default:
        return null;
    }
  }

  static String getStatusName(int? status) {
    switch (status) {
      case 1:

        /// 未认证
        return '未认证';
      case 3:

        /// 人工审核失败
        /// 去填写认证信息
        return '人工审核失败';
      case 2:

        /// 人工审核中
        return '人工审核中';
      case 4:

        /// 身份信息验证通过，待人脸验证
        return '身份信息验证通过，待人脸验证';
      case 6:

        /// 人工审核通过
        /// 打开人脸验证页面。 页面调整成功会吧人脸识别的url和id返回
        return '人工审核通过，待人脸验证';
      case 5:

        /// 已认证
        return '已认证';
      default:
        return '未认证';
    }
  }

  static Future<dynamic> startFaceVerify() async {
    LoadingUtils.showLoading();
    var mataInfos = await AliyunFacePlugin().getMetaInfos();
    var result = await fetchAsync(Method.post,
        url: '/msl-user/app/user/realName/getUserFaceRealNameInit',
        params: {
          'metaInfo': mataInfos,
          'productChannel': Platform.isIOS ? 'ios_app' : 'android_app'
        });
    LoadingUtils.dismiss();
    if (result.isError) {
      return null;
    }
    var certifyResult = result.data;
    var certifyId = certifyResult['certifyId'];
    debugPrint('认证结果：$certifyId');
    var verifyResult =
        await FaceAuthUtils.instance.startVerify(certifyId: certifyId);
    if (verifyResult == null) return certifyId;
    var resultArr = verifyResult.split(',');
    if (resultArr.getElement(0) != '1000') {
      return certifyId;
    }
    return certifyId;
  }

  static Future<bool> startVerifyWeb(String url) async {
    var completer = Completer<bool>();
    if (Platform.isIOS) {
      final result = await MethodChannel('account_center').invokeMethod(
        'startWebView',
        {'url': url},
      );
      print((result ?? '').toString());

      /// 签章吊起正常处理成功结果回调：{'result': 1,'type': 'sign'}
      /// 签章吊起正常处理失败结果回调：{'result': 0,'type': 'sign'}
      /// 实名认证正常吊起成功结果回调：{'result': 1,'type': 'realName'}
      /// 实名认证正常吊起失败结果回调：{'result': 0,'type': 'realName'}
      /// 实名认证异常吊起取消结果回调：{'result': -1,'type': 'realName'}
      /// 打开WebView用户点击返回按钮：{'result': -1,'type': 'cancel'}
      completer.complete(true);
    } else {
      requestPermission(
        toSettingTip: '设置摄像头权限',
        permissionList: [Permission.camera],
        onGranted: () {
          MethodChannel('account_center').invokeMethod(
            'startWebView',
            {'url': url},
          );
          completer.complete(true);
        },
        onRefuse: () {
          completer.complete(false);
        },
      );
    }

    return completer.future;
  }

  //查询人脸识别结果
  static Future<dynamic> getFaceIdentifyResult(dynamic id) async {
    Completer<dynamic> completer = Completer<dynamic>();
    LoadingUtils.showLoading();
    fetch(Method.get,
        url: '/msl-user/app/user/realName/getUserFaceRealNameResult',
        queryParameters: {"certifyId": id}, onSuccess: (data) {
      LoadingUtils.dismiss();
      completer.complete(data);
    }, onError: (code, msg) {
      LoadingUtils.dismiss();
      completer.complete(null);
    });
    return completer.future;
  }
}
