import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/format.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/common/utils/throttle_util.dart';
import 'package:account_center/page/account_center/account_info/account_info_state.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

import 'account_info_logic.dart';

class AccountInfoPage extends GetView<AccountInfoLogic> {
  AccountInfoLogic get logic => controller;

  AccountInfoState get state => logic.state;

  AccountInfoPage({super.key});

  final textStyleF = TextStyle(
    fontSize: 15,
    color: Color(0xFF344254),
    fontWeight: FontWeight.w500,
  );
  final textStyleL = TextStyle(
    fontSize: 15,
    color: Color(0xFFA4A8B1),
    fontWeight: FontWeight.w500,
  );

  final iconForward = Icon(
    Icons.arrow_forward_ios,
    color: Color(0xFFB4BAC6),
    size: 15,
  );

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("账户信息"),
      children: [
        GetBuilder<AccountInfoLogic>(
          builder: (logic) {
            // logic.checkReadStatus();
            return Container(
              margin: EdgeInsets.only(top: 10),
              child: Column(
                children: [
                  rowContent('头像', 60, [
                    SizedBox(
                      width: 50,
                      height: 50,
                      child: ImageLoad.user(state.avatar,
                          fit: BoxFit.cover,
                          domain: ossDomain,
                          type: ImageTransformerType.circle),
                    ),
                    hGap5,
                    iconForward
                  ], () {
                    logic.changeAvatar();
                  }),
                  rowContent('姓名', 50, [
                    Text(
                      state.name,
                      style: textStyleL,
                    ),
                    hGap5,
                    iconForward
                  ], () {
                    Get.toNamed(RouteConfig.modifyNamePage,
                        arguments: {'isRealName': logic.isRealNamed()});
                  }),
                  rowContent(
                    '手机号',
                    50,
                    [
                      Text(
                          style: textStyleL,
                          Format.getEllipsisPhone(state.phone)),
                      hGap5,
                      iconForward
                    ],
                    () {
                      Get.offNamed(RouteConfig.changePhone,
                          arguments: {'phone': state.phone});
                      // Get.toNamed(RouteConfig.changePhoneConfirm,
                      // arguments: {'phone': state.phone});
                    },
                  ),
                  SizedBox(height: 10),
                  rowContent('密码', 60, [
                    Text(style: textStyleL, "修改密码"),
                    hGap5,
                    iconForward,
                  ], () {
                    Get.toNamed(RouteConfig.changePasswordPage);
                  }),
                  SizedBox(height: 10),
                  _realName(),
                  // rowContent(
                  //     '个人签名',
                  //     60,
                  //     [
                  //       Text(style: textStyleL, logic.userSignStatusName),
                  //       hGap5,
                  //       iconForward
                  //     ],
                  //     logic.toUserSignPage),
                  Visibility(
                    visible: logic.isSignAuthorization,
                    child: rowContent(
                        '签订记录',
                        60,
                        [Text(style: textStyleL, '查看'), hGap5, iconForward],
                        logic.toSignRecordPage),
                  ),
                  SizedBox(height: 10),
                  rowContent('账号注销', 60, [
                    Text(style: textStyleL, '注销后无法恢复，请谨慎操作'),
                    hGap5,
                    iconForward
                  ], () {
                    Get.toNamed(RouteConfig.accountCancellationPage,
                        arguments: {'phone': state.phone});
                  })
                ],
              ),
            );
          },
        ),
      ],
    );
  }

  Widget rowContent(
      String title, double height, List<Widget> right, void Function()? onTap,
      {bool newMessage = false}) {
    return InkWell(
      onTap: onTap,
      child: Container(
        height: height,
        color: Colors.white,
        padding: EdgeInsets.only(left: 20, right: 20),
        child: Row(
          children: [
            Expanded(
              child: Row(
                children: [
                  Text(
                    title,
                    style: textStyleF,
                  ),
                  Visibility(
                    visible: newMessage,
                    child: Text(
                      '*',
                      style: textStyleF.copyWith(color: Colors.redAccent),
                    ),
                  )
                ],
              ),
            ),
            ...right
          ],
        ),
      ),
    );
  }

  Widget _realName() {
    Color statusColor;
    String statusText;
    String? secondText;
    switch (logic.realNameFlowNode) {
      case 1:
        statusColor = Color(0xFFA4A8B1);
        statusText = '未认证';
        break;
      case 2:

        /// 人工审核中
        statusColor = Color(0xFFE6A23C);
        statusText = '人工审核中';
        break;
      case 3:
        statusColor = Color(0xFFF56C6C);
        statusText = '重新上传';
        secondText = '人工审核未通过，原因：${logic.failReason ?? ''}';
        break;
      case 4:

        /// 人脸验证
        statusColor = Color(0xFF1F59EF);
        statusText = '人脸验证';
        break;
      case 5:

        /// 已完成实名
        statusColor = Color(0xFF67C23A);
        statusText = '已完成实名';
        break;
      case 6:

        /// 人脸验证
        statusColor = Color(0xFF1F59EF);
        statusText = '人脸验证';
        secondText = '人工审核已通过';
        break;
      default:
        statusColor = Color(0xFFA4A8B1);
        statusText = '未认证';
    }

    return InkWell(
      onTap: ThrottleUtil().throttle(logic.toUserIdentification),
      child: Container(
        color: Colors.white,
        padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
        child: Row(
          children: [
            Text(
              '实名认证',
              style: textStyleF,
            ),
            hGap15,
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.end,
                children: [
                  Text(
                    statusText,
                    style: textStyleL.copyWith(color: statusColor),
                    textAlign: TextAlign.right,
                  ),
                  Visibility(
                    visible: secondText?.isNotEmpty == true,
                    child: Container(
                      margin: EdgeInsets.only(top: 8),
                      child: Text(
                        secondText ?? '',
                        style: TextStyle(
                          color: Color(0xFF86909C),
                          fontSize: 13,
                        ),
                        textAlign: TextAlign.right,
                      ),
                    ),
                  )
                ],
              ),
            ),
            iconForward
          ],
        ),
      ),
    );
  }
}
