import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/format.dart';
import 'package:account_center/page/account_center/widget/account_cancellation_result.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class AccountCancellationLogic extends GetxController {
  String phone = '';

  List<dynamic> products = [];

  @override
  void onInit() {
    phone = Get.arguments['phone'];
    fetchList(Method.get,
        url: HttpApi.listUserProductsAll,
        queryParameters: {'userNo': getUserNo()}, onSuccess: (response) {
      products = response;
      update();
    });
    super.onInit();
  }

  String getShowPhone() {
    return Format.getEllipsisPhone(phone);
  }

  void cancellation() {
    fetch(
      Method.post,
      url: HttpApi.deleteUserAccount,
      params: {'userNo': getUserNo()},
      onSuccess: (response) {
        Get.off(AccountCancellationResult(response));
      },
    );
  }
}
