import 'package:account_center/common/widget/indicator_roundline.dart';
import 'package:flutter/material.dart';

class MyTabBar extends StatelessWidget {
  final List<String> tabs;
  final TabController? controller;
  final bool isScroll;
  final AlignmentGeometry alignment;
  final Color? indicatorColor;

  final void Function(int index)? onTap;
  const MyTabBar({
    Key? key,
    required this.tabs,
    this.controller,
    this.isScroll = true,
    this.alignment = Alignment.centerLeft,
    this.indicatorColor,
    this.onTap,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: alignment,
      child: TabBar(
        isScrollable: isScroll,
        tabs: tabs.map((str) => Text(str)).toList(),
        controller: controller,
        labelPadding: const EdgeInsets.symmetric(vertical: 8, horizontal: 15),
        indicatorSize: TabBarIndicatorSize.label,
        indicator: RoundLineIndicator(3.0,
            color: indicatorColor ?? Theme.of(context).primaryColor),
        unselectedLabelStyle:
            const TextStyle(fontSize: 15, fontWeight: FontWeight.w500),
        unselectedLabelColor: const Color(0xFF5B6F80),
        labelColor: const Color(0xFF222222),
        labelStyle: const TextStyle(fontSize: 15, fontWeight: FontWeight.w500),
        onTap: onTap,
      ),
    );
  }

  final tabTextStyle = const TextStyle(
    color: Color(0xff222222),
    fontSize: 15,
    fontWeight: FontWeight.w600,
  );
}
