import 'package:flutter/material.dart';

class RoundLineIndicator extends Decoration {
  final Color? color;
  final double width;
  final double height;
  const RoundLineIndicator(this.height, {this.color, this.width = 24});

  @override
  BoxPainter createBoxPainter([VoidCallback? onChanged]) {
    return _MyPainter(this);
  }
}

class _MyPainter extends BoxPainter {
  final Paint painter;
  final RoundLineIndicator indicator;

  _MyPainter(this.indicator)
      : painter = Paint()
          ..color = indicator.color ?? Colors.blue
          ..strokeCap = StrokeCap.round
          ..strokeWidth = indicator.height
          ..isAntiAlias = true;
  @override
  void paint(Canvas canvas, Offset offset, ImageConfiguration configuration) {
    var height = (configuration.size?.height ?? 0);
    var maxWidth = (configuration.size?.width ?? 0);
    var width = maxWidth < indicator.width ? maxWidth : indicator.width;
    var offSetX = (maxWidth - width) / 2;
    if (offSetX < 0) {
      offSetX = 0;
    }
    var startX = offSetX + offset.dx;
    var y = 0 + offset.dy + height - (indicator.height / 2);
    canvas.drawLine(Offset(startX, y), Offset(width + startX, y), painter);
  }
}
