import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

/// @class : LoadingDialog
/// @date : 2021/08/18
/// @name : jhf
/// @description :公共加载弹窗
class LoadingDialog extends StatelessWidget {
  final String? text;

  const LoadingDialog({
    super.key,
    this.text,
  });

  @override
  Widget build(BuildContext context) {
    return Material(
        //创建透明层
        type: MaterialType.transparency, //透明类型
        child: Center(
          //保证控件居中效果
          child: SizedBox(
            width: 100,
            height: 100,
            child: Container(
              decoration: const ShapeDecoration(
                color: Colors.black45,
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.all(
                    Radius.circular(8.0),
                  ),
                ),
              ),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: <Widget>[
                  Center(
                    child: CircularProgressIndicator(
                      color: Theme.of(context).primaryColor,
                    ),
                  ),
                  Text(text ?? '加载中',
                      style: TextStyle(color: Colors.white, fontSize: 14))
                ],
              ),
            ),
          ),
        ));
  }

  /// 隐藏加载框
  static void dismissLoading() {
    if (Get.isDialogOpen != null && Get.isDialogOpen!) {
      Get.back();
    }
  }

  /// 显示加载框
  static void showLoading({String text = ''}) {
    dismissLoading();
    Get.dialog(
      LoadingDialog(text: text),
      barrierDismissible: false,
      transitionDuration: const Duration(milliseconds: 200),
    );
  }
}
