import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

abstract class BottomDialog {
  static void showBottomDialog(List<ButtonItem> data) {
    if (data.isEmpty) return;
    List<Widget> buttons = [];
    for (int i = 0; i < data.length; i++) {
      var item = data[i];
      buttons.add(_contentLayout(item.title ?? '', () {
        Get.back();
        item.onClick?.call();
      }, textStyle: item.textStyle));
      if (i != data.length - 1) {
        buttons.add(_line());
      } else {
        buttons.add(_line(height: 8));
        buttons.add(_contentLayout('取消', () {
          Get.back();
        }));
      }
    }
    Get.bottomSheet(
      Container(
        decoration: const BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.only(
            topLeft: Radius.circular(10),
            topRight: Radius.circular(10),
          ),
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: buttons,
        ),
      ),
    );
  }

  static Widget _line({double height = 1}) {
    return Container(
      height: height,
      color: const Color(0xFFF5F5F5),
    );
  }

  static Widget _contentLayout(String title, void Function()? onTap,
      {TextStyle? textStyle}) {
    return InkWell(
      onTap: onTap,
      child: Container(
        height: 44,
        width: double.infinity,
        alignment: Alignment.center,
        child: Text(
          title,
          style: textStyle ??
              const TextStyle(
                color: Color(0xFF333C4C),
                fontSize: 15,
                fontWeight: FontWeight.w400,
              ),
        ),
      ),
    );
  }
}

class ButtonItem {
  ButtonItem({this.title, this.onClick, this.textStyle});

  String? title;
  void Function()? onClick;
  TextStyle? textStyle;
}
