import 'package:account_center/account_center.dart';
import 'package:account_center/themes/themes.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

void main() async {
  startAPP(UserAccountEnv.test);
}

void startAPP(UserAccountEnv env) {
  WidgetsFlutterBinding.ensureInitialized();
  AccountCenter.init(
    env,
    'msl-detection-app',
  );
  AccountCenter.initDeviceInfo();
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  Widget build(BuildContext context) {
    if (Theme.of(context).platform == TargetPlatform.android) {
      // android 平台
      SystemUiOverlayStyle style = const SystemUiOverlayStyle(
          statusBarColor: Colors.transparent,
          statusBarIconBrightness: Brightness.dark);
      SystemChrome.setSystemUIOverlayStyle(style);
    }
    return GetMaterialApp(
      title: 'Flutter driver',
      initialRoute: RouteConfig.loginPage,
      getPages: RouteConfig.routePages,
      builder: EasyLoading.init(),
      theme: Themes.main,
    );
  }
}
