package com.clx.account_center

import android.content.Context
import android.os.Environment
import io.flutter.embedding.engine.plugins.FlutterPlugin
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MethodChannel
import java.io.*
import java.nio.channels.FileChannel

object FileUtil {
  @Throws(IOException::class)
  fun copyFile(sourceFile: File, destFile: File) {
    if (destFile.parentFile?.exists() != true) {
      destFile.parentFile?.mkdirs()
    }
    var sourceChannel: FileChannel? = null
    var destChannel: FileChannel? = null
    try {
      sourceChannel = FileInputStream(sourceFile).channel
      destChannel = FileOutputStream(destFile).channel
      sourceChannel.transferTo(0, sourceChannel.size(), destChannel)
    } finally {
      sourceChannel?.close()
      destChannel?.close()
    }
  }

  @Throws(IOException::class)
  fun copyFileToOutStream(sourceFile: File, destFile: OutputStream) {
    try {
      destFile.read(FileInputStream(sourceFile))
      destFile.flush()
      destFile.close()
    } finally {
    }
  }

  fun OutputStream.read(input: FileInputStream) {
    use {
      input.use {
        var len: Int
        val buffer = ByteArray(1024)
        while (input.read(buffer).also { len = it } > 0) {
          write(buffer, 0, len)
        }
        flush()
      }
    }
  }
}


