import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/utils/bottom_dialog.dart';
import 'package:account_center/common/utils/permission_extenison.dart';
import 'package:account_center/common/widget/net_state_check.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

selectPicType({onSuccess, void Function()? onReset}) {
  BottomDialog.showBottomDialog(
    [
      ButtonItem(
          title: '拍照',
          onClick: () {
            Permission.camera
                .requestByTipDialog("为了实现拍照获取图片功能，请允许应用访问相机权限")
                .then((value) => {
                      if (value)
                        {
                          // 拍照权限已授权
                          selectPic(ImageSource.camera, onSuccess)
                        }
                    });
          }),
      ButtonItem(
          title: '相册',
          onClick: () {
            selectPic(ImageSource.gallery, onSuccess);
          }),
    ]..addIf(
        onReset != null,
        ButtonItem(
            title: '恢复默认',
            onClick: () {
              onReset?.call();
            }),
      ),
  );
}

//选择和加载图片
Future<void> selectPic(ImageSource source, onSuccess) async {
  var image = await ImagePicker().pickImage(source: source, imageQuality: 20);
  // 未选择图片时 返回值为null，不需要增加提示信息
  if (image == null) {
    return;
  }
  var connectivityResult = await NetUtil.hasNet();
  if (!connectivityResult) {
    ToastUtil.showToast('网络异常，请检查网络');
  } else {
    // 图片选择成功时，调用上传图片到服务器的方法
    String url = await uploadFile(path: image.path);
    onSuccess(url);
  }
}
