
import 'package:account_center/api/api_config.dart';
import 'package:account_center/widget/pdf_preview.dart';
import 'package:flutter/material.dart';

class PdfPage extends StatelessWidget {
  final String url;
  final String title;

  /// 临时文件全路径
  final String? tempFilePath;
  const PdfPage(
      {Key? key, required this.url, required this.title, this.tempFilePath})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    var tempUrl = url;
    if (!url.startsWith('http', 0)) {
      tempUrl = ossDomain + url;
    }
    return Scaffold(
      appBar: AppBar(
        title: Text(title),
      ),
      body: PdfPreview(tempUrl, tempFilePath: tempFilePath),
    );
  }
}
