import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class OneButtonDialog extends StatelessWidget {
  final String content;
  final String confirmButtonText;
  final Function()? confirm;
  const OneButtonDialog({
    super.key,
    required this.content,
    this.confirmButtonText = '确定',
    this.confirm,
  });

  void show() {
    Get.dialog(this, useSafeArea: true);
  }

  @override
  Widget build(BuildContext context) {
    return Dialog(
      child: Container(
        width: 270,
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(7),
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            ConstrainedBox(
              constraints: BoxConstraints(
                minHeight: 85,
              ),
              child: Container(
                alignment: Alignment.center,
                padding: EdgeInsets.symmetric(horizontal: 15, vertical: 10),
                child: Text(
                  content,
                  style: TextStyle(
                    color: Color(0xFF888888),
                    fontSize: 15,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ),
            ),
            Container(
              color: Color(0xFFDCDEE3),
              height: 0.5,
            ),
            GestureTapWidget(
              onTap: () {
                Get.back();
                confirm?.call();
              },
              child: Container(
                alignment: Alignment.center,
                color: Colors.transparent,
                height: 50,
                child: Text(
                  confirmButtonText,
                  style: TextStyle(
                    color: StyleParams.themeColor,
                    fontSize: 18,
                  ),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }
}
