import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

class MediaPreviewScreen extends StatefulWidget {
  final String title;
  final List<dynamic> mediaList;
  final int defaultIndex;

  const MediaPreviewScreen(
      {super.key,
      required this.mediaList,
      this.defaultIndex = 1,
      this.title = '视图预览'});

  @override
  State<StatefulWidget> createState() {
    return _MediaPreviewScreenState();
  }
}

class _MediaPreviewScreenState extends State<MediaPreviewScreen> {
  late List<dynamic> mediaList = widget.mediaList;

  late final PageController _pageController = PageController(
    initialPage: widget.defaultIndex,
  );
  late int _currentPage = widget.defaultIndex;

  @override
  void initState() {
    super.initState();
    _pageController.addListener(() {
      setState(() {
        _currentPage = _pageController.page!.round();
      });
    });
  }

  @override
  void dispose() {
    _pageController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(widget.title),
      ),
      body: Stack(
        children: [
          PageView.builder(
            controller: _pageController,
            itemCount: mediaList.length,
            itemBuilder: (context, index) {
              String url = '';
              var media = mediaList[index];
              if (media is String) {
                url = media;
              } else {
                if (media['type'] == 2) {
                  url = media['videoUrl'];
                } else {
                  url = media['imageUrl'];
                }
              }
              if (url.contains('https://') || url.contains('http://')) {
                return _previewPage(url);
              }
              return _previewPage(ossDomain + url);
            },
          ),
          Visibility(
            visible: mediaList.length > 1,
            child: Positioned(
              bottom: 16.0,
              left: 0,
              right: 0,
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: List.generate(mediaList.length, (index) {
                  return Container(
                    width: 10.0,
                    height: 10.0,
                    margin: const EdgeInsets.symmetric(horizontal: 4.0),
                    decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      color: _currentPage == index ? Colors.blue : Colors.grey,
                    ),
                  );
                }),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget _previewPage(media) {
    if (media.endsWith('.jpg') ||
        media.endsWith('.png') ||
        media.endsWith('.PNG')) {
      return ImagePreview(url: media);
    } else {
      return const Center(child: Text('Unsupported media format'));
    }
  }
}

class ImagePreview extends StatelessWidget {
  final String url;

  const ImagePreview({super.key, required this.url});

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Image.network(url),
    );
  }
}
