import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/svg_path.dart';
import 'package:flutter/material.dart';

class GlobalCardWidget extends StatelessWidget {
  final Widget? centerWidget; //中间view
  final VoidCallback? onTab; //点击事件
  final Widget? iconWidget; //尾部图标 只负责样式不负责逻辑 widget
  final double iconSize;
  final Widget? hintFillWidget; //尾部图标 只负责样式不负责逻辑 widget
  final bool isVisHintFill; //尾部图标 只负责样式不负责逻辑 widget
  final bool isHeaderVis;
  final Color backgroundColor;
  final double paddingAll;
  final double paddingTop;
  final double paddingBottom;
  final double paddingLeft;
  final double paddingRight;
  final double paddingH;
  final double paddingV;
  final double marginAll;
  final double marginTop;
  final double marginBottom;
  final double marginLeft;
  final double marginRight;
  final double marginH;
  final double marginV;
  final double borderRadius;
  final double elevation;

  const GlobalCardWidget(
      {Key? key,
      this.onTab,
      this.centerWidget,
      this.iconWidget,
      this.iconSize = 20,
      this.backgroundColor = Colors.white,
      this.isHeaderVis = false,
      this.marginAll = 0,
      this.marginLeft = 0,
      this.marginTop = 0,
      this.marginRight = 0,
      this.marginBottom = 0,
      this.marginH = 0,
      this.marginV = 0,
      this.paddingAll = 0,
      this.paddingBottom = 0,
      this.paddingLeft = 0,
      this.paddingRight = 0,
      this.paddingTop = 0,
      this.paddingH = 0,
      this.paddingV = 0,
      this.hintFillWidget,
      this.isVisHintFill = true,
      this.borderRadius = 7,
      this.elevation = 2})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return _itemView();
  }

  Widget _itemView() {
    return Card(
        color: backgroundColor,
        shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(borderRadius)),
        elevation: elevation,
        margin: margin(),
        child: InkWell(
          borderRadius: BorderRadius.all(Radius.circular(borderRadius)),
          onTap: () {
            onTab!();
          },
          child: Container(
            padding: padding(),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Offstage(
                  offstage: isHeaderVis,
                  child: ImageLoad.svgTagIconByPath(SvgPath.roleIcon()),
                ),
                Offstage(
                  offstage: isHeaderVis,
                  child: hGap15,
                ),
                Expanded(child: centerWidget ?? Row()),
                Offstage(offstage: isVisHintFill, child: hintFillWidget),
                Offstage(
                  offstage: isVisHintFill,
                  child: hGap8,
                ),
                iconWidget ??
                    Icon(
                      size: iconSize,
                      Icons.arrow_forward_ios,
                      color: Colors.grey[400],
                    )
              ],
            ),
          ),
        ));
  }

  padding() {
    if (paddingLeft > 0 ||
        paddingTop > 0 ||
        paddingRight > 0 ||
        paddingBottom > 0) {
      return EdgeInsets.fromLTRB(
          paddingLeft, paddingTop, paddingRight, paddingBottom);
    } else if (paddingH > 0 || paddingV > 0) {
      return EdgeInsets.symmetric(horizontal: paddingH, vertical: paddingV);
    } else {
      return EdgeInsets.all(paddingAll);
    }
  }

  margin() {
    if (marginLeft > 0 ||
        marginTop > 0 ||
        marginRight > 0 ||
        marginBottom > 0) {
      return EdgeInsets.fromLTRB(
          marginLeft, marginTop, marginRight, marginBottom);
    } else if (paddingH > 0 || paddingV > 0) {
      return EdgeInsets.symmetric(horizontal: marginH, vertical: marginV);
    } else {
      return EdgeInsets.all(marginAll);
    }
  }
}
