import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';

/// 表单输入框展示
class FormSelect extends StatelessWidget {
  final String title;
  final String? content;
  final bool onlyShow;
  final void Function()? onTap;

  const FormSelect(
      {Key? key,
      required this.title,
      required this.content,
      this.onTap,
      this.onlyShow = false})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return FormRow(
      title: title,
      isRequired: false,
      crossAxisAlignment: CrossAxisAlignment.center,
      child: GestureTapWidget(
        onTap: onlyShow ? null : onTap,
        child: Row(
          children: [
            Expanded(
              child: Text(
                content ?? '',
                style: TextStyle(
                    color: Color(0xff344254),
                    fontSize: 16,
                    fontWeight: FontWeight.w500,
                    height: 1.4),
              ),
            ),
            Visibility(
              visible: !onlyShow,
              child: Icon(
                Icons.arrow_forward_ios,
                size: 16,
                color: Color(0xffA4A8B1),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
