import 'package:flutter/material.dart';

class BottomSafeArea extends StatelessWidget {
  final Widget child;
  final Color? color;
  const BottomSafeArea({
    Key? key,
    this.child = const SizedBox(),
    this.color = Colors.white,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    var bottom = MediaQuery.of(context).padding.bottom;
    return Container(
      color: color,
      padding: EdgeInsets.only(bottom: bottom == 0 ? 10 : bottom),
      child: child,
    );
  }
}
