import 'package:flutter/material.dart';

class AssetImageWidget extends StatelessWidget {
  final String imgFileName;
  final String imgFormat;
  final double? width;
  final double? height;
  final BoxFit? fit;
  final Color? color;
  final int? cacheWidth;
  final int? cacheHeight;

  const AssetImageWidget(
      {Key? key,
      required this.imgFileName,
      this.imgFormat = 'png',
      this.width,
      this.height,
      this.fit,
      this.color,
      this.cacheWidth,
      this.cacheHeight})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Image.asset(
      getImgPath(imgFileName, format: imgFormat),
      height: height,
      width: width,
      cacheWidth: cacheWidth,
      cacheHeight: cacheHeight,
      fit: fit,
      color: color,

      /// 忽略图片语义
      excludeFromSemantics: true,
    );
  }

  static ImageProvider getNetworkImage(String name, {String format = 'png'}) {
    return NetworkImage(name);
  }

  static ImageProvider getAssetImage(String name, {String format = 'png'}) {
    return AssetImage(getImgPath(name, format: format));
  }

  static String getImgPath(String? name, {String format = 'png'}) {
    return 'packages/account_center/assets/images/$name.$format';
  }

  static String getSVGPath(String name, {String format = 'svg'}) {
    return 'packages/account_center/assets/svg/$name.$format';
  }
}
