import 'package:account_center/api/api_config.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class MyAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String? title;
  final Color? backgroundColor;
  final Color? foregroundColor;
  final bool showBack;
  final bool primary;
  final Function()? onBack;
  final List<Widget>? actions;
  final bool exitApp;
  final Widget? leading;
  final double? elevation;

  const MyAppBar(
    this.title, {
    Key? key,
    this.backgroundColor,
    this.foregroundColor,
    this.showBack = true,
    this.primary = true,
    this.onBack,
    this.actions,
    this.exitApp = false,
    this.leading,
    this.elevation,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return AppBar(
      flexibleSpace: Container(
        decoration:
            StyleParams.appBarBgModel == 3 && StyleParams.appBarBgUrl != ''
                ? BoxDecoration(
                    image: DecorationImage(
                      image: NetworkImage(ossDomain + StyleParams.appBarBgUrl),
                      fit: BoxFit.cover,
                    ),
                  )
                : null,
      ),
      key: key,
      centerTitle: true,
      title: Text(title ?? "",
          style:
              TextStyle(color: foregroundColor ?? StyleParams.appBarTextColor)),
      backgroundColor: backgroundColor ?? StyleParams.getAppBarBgColor(),
      foregroundColor: foregroundColor ?? StyleParams.appBarTextColor,
      primary: primary,
      actions: actions,
      leading: leading,
      elevation: elevation,
    );
  }

  @override
  Size get preferredSize => const Size(double.infinity, 55.0);
}
