import 'dart:ui';

abstract class StyleParams {
  /// 主题色
  static Color themeColor = Color(0xff2BD193);

  /// appBar 背景色  1:跟随系统、2:白色、3:图片
  static int appBarBgModel = 1;

  static String appBarBgUrl = '';

  static Color appBarTextColor = Color(0xFFFFFFFF);

  static Color? getAppBarBgColor() {
    if (appBarBgModel == 1) {
      return themeColor;
    } else if (appBarBgModel == 2) {
      return Color(0xFFFFFFFF);
    } else {
      return null;
    }
  }

  ///按钮是否是圆角
  static bool buttonIsCircle = false;

  /// 用户首页背景图
  static String? userHomeBgUrl;

  /// 公司首页背景图
  static String? companyHomeBgUrl;

  /// 公司首页背景图
  static String? userDetailBg;

  static Color companyCardBgColor = Color(0xFF3C3F53);

  static Color companyCardTitleColor = Color(0xFFFFDEB9);

  static Color companyCardSecondTitleColor = Color(0xFFFFDDB4);

  static Color companyInBgTargetColor = Color(0x33FFFFFF);

  static void setCompanyCardBgColor(int companyCardType) {
    switch (companyCardType) {
      case 1:
        companyCardBgColor = Color(0xFF3C3F53);
        companyCardTitleColor = Color(0xFFFFDEB9);
        companyCardSecondTitleColor = Color(0xFFFFDDB4);
        companyInBgTargetColor = Color(0x33FFFFFF);
        break;
      case 2:
        companyCardBgColor = Color(0xFFFFFFFF);
        companyCardTitleColor = Color(0xFF171A1D);
        companyCardSecondTitleColor = Color(0xFF76777C);
        companyInBgTargetColor = Color(0xFFE9E9E9);
        break;
      case 3:
        companyCardBgColor = Color(0xFFFFDEB9);
        companyCardTitleColor = Color(0xFF513F2A);
        companyCardSecondTitleColor = Color(0xFFA38A6D);
        companyInBgTargetColor = Color(0xFFF6C38A);
        break;
    }
  }
}
