import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/themes/themes.dart';
// import 'package:account_center/widget/asset_image_widget.dart';
// import 'package:account_center/widget/select_image_utils.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class TestMenuLogic extends GetxController {
  @override
  void onReady() {
    print((getToken() ?? '') + '-----------');
    if (getToken()?.isNotEmpty == true) {
      print(getToken());
      Get.offAllNamed(RouteConfig.accountCenterPage);
    }
    super.onReady();
  }
}

class TestMenu extends GetView<TestMenuLogic> {
  const TestMenu({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<TestMenuLogic>(builder: (logic) {
      return MyScaffold(
        appBar: MyAppBar('测试菜单'),
        children: [
          TextButton(
              onPressed: () {
                Get.toNamed(RouteConfig.loginPage);
              },
              child: const Text("登录")),
          // TextButton(
          //     onPressed: () {
          //       Get.bottomSheet(themeSelect());
          //     },
          //     child: const Text("改变主题")),
          // TextButton(
          //     onPressed: () {
          //       Get.toNamed(RouteConfig.staffManagerMainPage);
          //     },
          //     child: const Text("员工管理")),
          // TextButton(
          //     onPressed: () {
          //       Get.toNamed(RouteConfig.accountCenterPage);
          //     },
          //     child: const Text("账户中心")),
          // InkWell(
          //   onTap: () {
          //     selectPicType(onSuccess: (data) {
          //       loggerNoStack.d("成功");
          //     });
          //   },
          //   child: AssetImageWidget(
          //     imgFileName: "head",
          //     width: 50,
          //     height: 50,
          //   ),
          // ),
        ],
      );
    });
  }

  //主题选择
  Widget themeSelect() {
    return Container(
      color: Colors.white,
      height: 150,
      width: double.infinity,
      child: Column(
        children: [
          TextButton(
              onPressed: () {
                Get.changeTheme(Themes.black);
                Get.back();
              },
              child: const Text("黑色主题")),
          TextButton(
              onPressed: () {
                Get.changeTheme(Themes.white);
                Get.back();
              },
              child: const Text("白色主题")),
          TextButton(
              onPressed: () {
                Get.changeTheme(Themes.purple);
                Get.back();
              },
              child: const Text("紫色主题")),
        ],
      ),
    );
  }
}

class TestMenuBinding extends Bindings {
  @override
  void dependencies() {
    Get.lazyPut(() => TestMenuLogic());
  }
}
