import 'package:account_center/account_center.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/widget/demartment_manager_tag.dart';
import 'package:flutter/material.dart';

class UserDepartments extends StatelessWidget {
  final List<dynamic> listData;
  final void Function()? onCheck;
  final String title;
  const UserDepartments(this.listData,
      {Key? key, this.onCheck, this.title = '部门'})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureTapWidget(
      onTap: onCheck,
      child: Container(
        decoration: BoxDecoration(
          color: const Color(0xffFFFFFF),
          borderRadius: BorderRadius.circular(8),
        ),
        padding: const EdgeInsets.symmetric(horizontal: 10),
        child: Column(
          children: [
            SizedBox(height: 15),
            _titleMessage(),
            SizedBox(height: 10),
            ...listData.map((e) {
              return _departmentMessage(e);
            }),
            SizedBox(height: 10),
          ],
        ),
      ),
    );
  }

  Container _departmentMessage(e) {
    return Container(
      margin: const EdgeInsets.only(top: 10),
      padding: const EdgeInsets.symmetric(horizontal: 10),
      decoration: BoxDecoration(
        color: const Color(0xFFF5F6FA),
        borderRadius: BorderRadius.circular(8),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          SizedBox(height: 13),
          Row(
            children: [
              Flexible(
                child: Text(
                  e['departmentName'] ?? SpUtil.getString(SPKey.companyName),
                  style: TextStyle(
                    color: Color(0xFF344254),
                    fontSize: 15,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ),
              SizedBox(width: 14),
              Visibility(
                visible: e['userType'] == 2 && onCheck == null,
                child: DepartmentManagerTag(title: '负责人'),
              ),
            ],
          ),
          SizedBox(height: 10),
          Wrap(
            spacing: 10,
            runSpacing: 10,
            children: [
              ...(e['roleVos'] ?? []).map((role) {
                return Container(
                  padding:
                      const EdgeInsets.symmetric(horizontal: 10, vertical: 7),
                  decoration: BoxDecoration(
                    color: const Color(0xFFFFFFFF),
                    borderRadius: BorderRadius.circular(4),
                  ),
                  child: Text(
                    role['roleName'] ?? '',
                    style: TextStyle(
                      color: Color(0xFF76777C),
                      fontSize: 12,
                      fontWeight: FontWeight.w400,
                    ),
                  ),
                );
              }).toList(),
            ],
          ),
          SizedBox(height: 15),
        ],
      ),
    );
  }

  Row _titleMessage() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Text(
          title,
          style: TextStyle(
            color: Color(0xFF344254),
            fontSize: 15,
            fontWeight: FontWeight.w500,
          ),
        ),
        Visibility(
          visible: onCheck != null,
          child: Icon(
            Icons.arrow_forward_ios,
            size: 15,
            color: Color(0xFFB4BAC6),
          ),
        ),
      ],
    );
  }
}
