import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/widget/bottom_buttons.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'no_depart_user_list_logic.dart';

class NoDepartUserListPage extends StatelessWidget {
  final logic = Get.find<NoDepartUserListLogic>();

  NoDepartUserListPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('未分配人员'),
      body: GetBuilder<NoDepartUserListLogic>(builder: (logic) {
        return Column(
          children: [
            Expanded(
              child: MyListViewPublic(
                itemBuilder: _itemBuilder,
                requestData: logic.requestData,
                controller: logic.controller,
                pageSize: 500,
              ),
            ),
            _buildButton(),
          ],
        );
      }),
    );
  }

  _itemBuilder(BuildContext context, int index, item) {
    return _makeUserItem(item);
  }

  Widget _buildButton() {
    return BottomButtons(items: [
      ButtonItem(
        title: '添加人员',
        onClick: logic.addPeople,
      ),
      ButtonItem(
        title: '批量变更部门',
        onClick: logic.changeDepartment,
      )
    ]);
  }

  GestureTapWidget _makeUserItem(staff) {
    return GestureTapWidget(
      onTap: () => logic.toUserDetail(staff),
      child: Container(
        margin: EdgeInsets.only(left: 10, right: 10, top: 10),
        padding: EdgeInsets.all(20),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            SizedBox(
              height: 42,
              width: 42,
              child: ImageLoad.user(staff['headImg'],
                  fit: BoxFit.cover, type: ImageTransformerType.circle),
            ),
            hGap15,
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    staff['userName'] ?? '',
                    style: RTextStyle.mainContentStyle,
                  ),
                  vGap4,
                  Text(
                    staff['userMobile'] ?? '',
                    style: TextStyle(
                      color: RColors.hintColor,
                      fontSize: 12,
                    ),
                  ),
                ],
              ),
            ),
            Icon(
              size: 20,
              Icons.arrow_forward_ios,
              color: Colors.grey[400],
            )
          ],
        ),
      ),
    );
  }
}
