import 'department_and_position_vos.dart';

class StaffModel {
  StaffModel(
      {this.companyName,
      this.departmentAndPositionVos,
      this.id,
      this.inductionTime,
      this.status,
      this.statusMsg,
      this.type,
      this.typeMsg,
      this.userMobile,
      this.userName,
      this.userNo,
      this.isChecked = false});

  StaffModel.fromJson(dynamic json) {
    companyName = json['companyName'];
    id = json['id'];
    inductionTime = json['inductionTime'];
    status = json['status'];
    statusMsg = json['statusMsg'];
    type = json['type'];
    typeMsg = json['typeMsg'];
    userMobile = json['userMobile'];
    userName = json['userName'];
    userNo = json['userNo'];
    authStatus = json['authStatus'];
    authStatus = json['authStatus'];
    isChecked = json['isChecked'];
    headImg = json['headImg'];
  }
  String? companyName;
  List<DepartmentAndPositionVos>? departmentAndPositionVos;
  int? id;
  String? inductionTime;
  int? status;
  String? statusMsg;
  int? type;
  String? typeMsg;
  String? userMobile;
  String? userName;
  String? userNo;
  bool? isChecked = false;
  String? headImg;

  /// 认证状态:10-未注册,20-待实名,30-已实名
  int? authStatus;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['companyName'] = companyName;
    if (departmentAndPositionVos != null) {
      map['departmentAndPositionVos'] =
          departmentAndPositionVos?.map((v) => v.toJson()).toList();
    }
    map['id'] = id;
    map['inductionTime'] = inductionTime;
    map['status'] = status;
    map['statusMsg'] = statusMsg;
    map['type'] = type;
    map['typeMsg'] = typeMsg;
    map['userMobile'] = userMobile;
    map['userName'] = userName;
    map['userNo'] = userNo;
    map['authStatus'] = authStatus;
    map['isChecked'] = isChecked;
    map['headImg'] = headImg;
    return map;
  }

  @override
  // TODO: implement hashCode
  int get hashCode => id.hashCode;

  @override
  bool operator ==(Object other) {
    if (identical(this, other)) return true;
    if (other is StaffModel) {
      return runtimeType == other.runtimeType && id == other.id;
    } else {
      return false;
    }
  }
}
