import 'package:account_center/page/staff_manager/widget/user_departments.dart';
import 'package:account_center/page/staff_manager/widget/user_message_show.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'edit_people_logic.dart';

class EditPeoplePage extends StatelessWidget {
  final logic = Get.find<EditPeopleLogic>();

  EditPeoplePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: '编辑人员',
        showCancel: false,
        confirm: logic.submit,
      ),
      body: GetBuilder<EditPeopleLogic>(builder: (logic) {
        return Padding(
          padding: const EdgeInsets.symmetric(horizontal: 10),
          child: Column(
            children: [
              SizedBox(
                height: 10,
              ),
              UserDepartments(
                logic.departmentList,
                title: '分配部门',
                onCheck: logic.selectDepartment,
              ),
              SizedBox(
                height: 10,
              ),
              UserMessageShow(
                logic.roleList,
                title: '分配角色',
                onCheck: logic.selectRole,
                nameKey: 'roleName',
              ),
              SizedBox(
                height: 10,
              ),
              UserMessageShow(
                logic.positionList,
                title: '分配职位',
                nameKey: 'positionName',
                onCheck: logic.selectPosition,
              ),
            ],
          ),
        );
      }),
    );
  }
}
