import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class EditPeopleLogic extends GetxController {
  List<dynamic> departmentList = [];
  List<String> departmentNos = <String>[];
  var roleList = [];
  var positionList = [];
  String userNo = '';

  @override
  void onInit() {
    userNo = Get.arguments['userNo'] ?? '';
    requestDetail();
    super.onInit();
  }

  /// 获取详情
  void requestDetail() {
    fetch(Method.get,
        url: HttpApi.getEmpDetailGroupByRolesWithType,
        queryParameters: {
          'companyNo': SpUtil.getString(SPKey.companyNo),
          'userNo': userNo,
        }, onSuccess: (response) {
      if (response == null) return;
      roleList = response['roles'] ?? [];
      positionList = response['positions'] ?? [];
      departmentList = response['deptAndRoles'] ?? [];
      departmentNos = departmentList
          .map<String>((e) => e['departmentNo'].toString())
          .toList();
      LoadingUtils.dismiss();
      update();
    }, onError: (code, msg) {
      ToastUtil.showToast(msg);
      LoadingUtils.dismiss();
    });
  }

  void selectDepartment() {
    Get.toNamed(RouteConfig.departmentSelectPage,
        arguments: {'selectedNos': departmentNos})?.then((value) {
      if (value != null) {
        departmentList.clear();
        departmentList.addAll(value);
        departmentNos = departmentList
            .map<String>((e) => e['departmentNo'].toString())
            .toList();
        update();
        if (departmentNos.isNotEmpty) {
          _requestDepartmentRoleList();
        }
      }
    });
  }

  void selectRole() {
    Get.toNamed(RouteConfig.roleSelectPage, arguments: {'selectData': roleList})
        ?.then((value) {
      if (value != null) {
        roleList.clear();
        roleList.addAll(value);
        update();
      }
    });
  }

  void selectPosition() {
    Get.toNamed(RouteConfig.positionSelectPage,
        arguments: {'selectData': positionList})?.then((value) {
      if (value != null) {
        positionList.clear();
        positionList.addAll(value);
        update();
      }
    });
  }

  void submit() {
    var roleNos = roleList.map<String>((e) => e['roleNo'].toString()).toList();
    var positionNos =
        positionList.map<String>((e) => e['positionNo'].toString()).toList();
    var departmentNos = departmentList
        .map<String>((e) => e['departmentNo'].toString())
        .toList();
    fetch(Method.post, url: HttpApi.saveDeptUserConfig, params: {
      'companyNo': SpUtil.getString(SPKey.companyNo),
      'userNo': userNo,
      'roleNos': roleNos,
      'positionNos': positionNos,
      'departmentNos': departmentNos,
    }, onSuccess: (response) {
      ToastUtil.showToast('编辑成功');
      Get.back(result: true);
    }, onError: (code, msg) {});
  }

  void _requestDepartmentRoleList() {
    fetchList(
      Method.post,
      url: HttpApi.departmentRoles,
      params: {
        'departmentNos': departmentNos,
      },
      onSuccess: (response) {
        departmentList.clear();
        departmentList.addAll(response);
        update();
      },
      onError: (code, msg) {
        ToastUtil.showToast(msg);
      },
    );
  }
}
