import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/form/form_edit_clear.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'staff_add_logic.dart';

class StaffAddPage extends StatelessWidget {
  final logic = Get.find<StaffAddLogic>();
  final state = Get.find<StaffAddLogic>().state;

  StaffAddPage({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<StaffAddLogic>(builder: (logic) {
      return MyScaffold(
        appBar: EditAppBar(
          title: '新建人员',
          confirm: logic.submit,
          confirmText: '下一步',
          showCancel: false,
        ),
        body: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            vGap10,
            FormInput(
              title: '手机号',
              controller: state.phoneController,
              focusNode: state.phoneNode,
              inputType: TextInputType.number,
              maxLength: 11,
              changed: logic.onPhoneNumberInput,
            ),
            FormInput(
              title: '人员名称',
              controller: state.nameController,
              focusNode: state.nameNode,
              maxLength: 10,
              enabled: state.enabledName,
            ),
            FormRow(
              title: '验证码添加',
              child: Row(
                children: [
                  _radio('否', false),
                  hGap10,
                  _radio('是', true),
                ],
              ),
            ),
            Visibility(
              visible: state.isVerify,
              child: FormRow(
                  title: '验证码',
                  vCap: 4,
                  child: Row(
                    children: [
                      Expanded(
                        child: FormEditClear(
                          focusNode: state.codeNode,
                          controller: state.codeController,
                          hint: '请输入验证码',
                          maxLength: 6,
                          inputType: TextInputType.number,
                        ),
                      ),
                      hGap10,
                      SendVCode(
                        'captchaUserAddEmp',
                        () => state.phoneController.text,
                      )
                    ],
                  )),
            ),
          ],
        ),
      );
    });
  }

  Widget _radio(String title, bool value) {
    return StyleWidget.itemRadio(value, state.isVerify, title, (value) {
      logic.verifyChange(value);
    });
  }
}
