import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

class PositionManageLogic extends GetxController {
  var positionListController = MyListController();
  var key = '';
  search(data) {
    key = data;
    positionListController.callRefresh();
  }

  void searchKeyChange(String value) {
    key = value;
    positionListController.callRefresh();
  }

  void requestPositionList(
      int page, int pageSize, SuccessCallback success, ErrorCallback error) {
    fetch(
      Method.post,
      url: HttpApi.listCompanyPositions,
      params: {
        'page': page,
        'pageSize': pageSize,
        'positionName': key,
        'companyNo': SpUtil.getString(SPKey.companyNo)
      },
      onSuccess: (response) {
        success(response['records']);
      },
      onError: (code, message) {
        error(code, message);
      },
    );
  }

  void editPosition(data) {
    Get.toNamed(RouteConfig.positionDetailPage, arguments: data)?.then((value) {
      positionListController.callRefresh();
    });
  }

  void newPosition() {
    Get.toNamed(RouteConfig.editOrNewPositionPage)?.then((value) {
      if (value != null) {
        positionListController.callRefresh();
      }
    });
  }
}
