import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/role_details_logic.dart';
import 'package:account_center/style/widget/bottom_layout_button.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class UserListPage extends StatelessWidget {
  final logic = Get.find<RoleDetailsLogic>();
  final state = Get.find<RoleDetailsLogic>().state;

  UserListPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<RoleDetailsLogic>(builder: (logic) {
      return Column(
        children: [
          Expanded(
            child: _productListWidget(),
          ),
          SizedBox(
            height: 5,
          ),
          Visibility(
            visible: hasMenuPermission('btn_role_add_user'),
            child: BottomLayoutButton(
              name: '添加人员',
              onPress: logic.addUser,
            ),
          )
        ],
      );
    });
  }

  ///列表
  Widget _productListWidget() {
    return logic.userList.isEmpty
        ? NoData()
        : ListView.builder(
            itemBuilder: (context, index) {
              return _makeUserItem(logic.userList[index]);
            },
            itemCount: logic.userList.length,
          );
  }

  GestureTapWidget _makeUserItem(staff) {
    return GestureTapWidget(
      child: Container(
        padding: EdgeInsets.all(15),
        margin: EdgeInsets.only(left: 10, right: 10, top: 10),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            InkWell(
              onTap: () {
                logic.deletePerson(staff);
              },
              child: Visibility(
                visible: hasMenuPermission('btn_update_role'),
                child: Container(
                  margin: EdgeInsets.only(right: 5),
                  child: Icon(
                    Icons.remove_circle_outlined,
                    color: Colors.red,
                  ),
                ),
              ),
            ),
            SizedBox(
              height: 42,
              width: 42,
              child: ImageLoad.user(staff['headImg'],
                  fit: BoxFit.cover, type: ImageTransformerType.circle),
            ),
            hGap15,
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    staff['userName'] ?? '',
                    style: RTextStyle.mainContentStyle,
                  ),
                  vGap4,
                  Text(
                    staff['userMobile'] ?? '',
                    style: TextStyle(
                      color: RColors.hintColor,
                      fontSize: 12,
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
