import 'package:account_center/common/res/colors.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class StructureTopBar extends StatefulWidget {
  final List<dynamic> departments;
  const StructureTopBar(this.departments, {Key? key}) : super(key: key);

  @override
  State<StructureTopBar> createState() => _StructureTopBarState();
}

class _StructureTopBarState extends State<StructureTopBar> {
  late List<dynamic> departments;
  // final ScrollController _controller = ScrollController();
  @override
  void initState() {
    departments = widget.departments;
    super.initState();
    // _controller.animateTo(
    //   _controller.position.maxScrollExtent,
    //   duration: Duration(milliseconds: 100),
    //   curve: Curves.ease,
    // );
  }

  @override
  Widget build(BuildContext context) {
    if (departments.isEmpty) {
      return Container();
    }
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.symmetric(vertical: 15, horizontal: 20),
      color: Color(0xFFFFFFFF),
      alignment: Alignment.centerLeft,
      child: SingleChildScrollView(
        reverse: true,
        scrollDirection: Axis.horizontal,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            ...getParentTitle(),
            Text(
              getDepartmentTitle(departments.last),
              style: TextStyle(
                color: RColors.mainContentColor,
                fontSize: 14,
                fontWeight: FontWeight.w500,
              ),
            ),
          ],
        ),
      ),
    );
  }

  String getDepartmentTitle(dynamic department, {bool showNum = false}) {
    if (department['departmentNo'] == null) {
      return department['companyName'] ?? '';
    } else {
      var num = showNum ? ('（${department['empNum']?.toString() ?? '0'}）') : '';
      return department['departmentName'] + num;
    }
  }

  /// 父部门标题
  List<Widget> getParentTitle() {
    List<Widget> parentTitles = [];
    if (departments.isEmpty) {
      return [Container()];
    }
    for (var element in departments.sublist(0, departments.length - 1)) {
      parentTitles.add(GestureTapWidget(
        onTap: () {
          Get.back(result: {'departmentNo': element['departmentNo']});
        },
        child: Text(
          getDepartmentTitle(element),
          style: TextStyle(
            color: RColors.mainContentColor,
            fontWeight: FontWeight.w400,
            fontSize: 14,
          ),
        ),
      ));
      parentTitles.add(SizedBox(
        width: 5,
      ));
      parentTitles.add(Icon(
        Icons.arrow_forward_ios_rounded,
        size: 20,
        color: Color(0xFFDDE0E5),
      ));
    }
    return parentTitles;
  }
}
