import 'package:account_center/page/staff_manager/widget/user_departments.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'set_user_department_logic.dart';

class SetUserDepartmentPage extends StatelessWidget {
  final logic = Get.find<SetUserDepartmentLogic>();

  SetUserDepartmentPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: '编辑人员',
        confirmText: '完成',
        confirm: () {
          logic.confirm();
        },
        showCancel: false,
      ),
      body: GetBuilder<SetUserDepartmentLogic>(builder: (logic) {
        return SingleChildScrollView(
          child: Padding(
            padding: const EdgeInsets.all(10.0),
            child: UserDepartments(
              logic.departmentList,
              title: '分配部门',
              onCheck: logic.selectDepartment,
            ),
          ),
        );
      }),
    );
  }
}
